import AppletError from './AppletError';
import { IBaseSosErrorParams } from './SosError';

export interface IAppletBrowserErrorParams extends IBaseSosErrorParams {
	kind: 'appletBrowserError';
}

export default class AppletBrowserError extends AppletError {
	public static readonly PATH_TO_DOCS: string = '/api/js/js-browser';

	constructor(parameters: IAppletBrowserErrorParams) {
		super({
			...parameters,
			pathToDocs: AppletBrowserError.PATH_TO_DOCS,
			kind: 'appletError',
		});
		this.name = 'AppletBrowserError';
	}
}
