import IDriver from '../../../NativeDevice/Front/IFrontDriver';
import IDisplaySupportsMessage from './IDisplaySupportsMessage';
import FrontCapability from '../../../NativeDevice/Front/FrontCapability';
import AppletDisplayError from '../Error/AppletDisplayError';
import ErrorCodes from '../Error/ErrorCodes';
import { HandlerResult, IHandlerParams } from '../IHandler';

export function* handleDisplayMessage(messageTypePrefix: string, data: IDisplaySupportsMessage, nativeDriver: IDriver): HandlerResult {
	switch (data.type) {
		case messageTypePrefix + '.display.supports':
			const result = yield isCapabilitySupported(data, nativeDriver);
			return result;
		default:
			return null;
	}
}

async function isCapabilitySupported(data: IDisplaySupportsMessage, nativeDriver: IDriver) {
	const capability = FrontCapability[data.capability];
	if (typeof capability === 'undefined') {
		throw new AppletDisplayError({
			kind: 'appletDisplayError',
			message: 'Invalid capability',
			code: ErrorCodes.DISPLAY_CAPABILITY_INVALID,
		});
	}

	const supports = await nativeDriver.frontSupports(capability);
	return { supports };
}

export default function* displayHandler({ messageTypePrefix, data, frontDriver }: IHandlerParams): HandlerResult {
	return yield handleDisplayMessage(messageTypePrefix, data as IDisplaySupportsMessage, frontDriver);
}
