import { HandlerResult, IHandlerParams } from '../IHandler';
import { IDeviceInfoGetLocationMessage, IDeviceInfoGetLocationResponseData } from './IDeviceInfoGetLocationMessage';
import { IDeviceInfoGetOrganizationTagsMessage, IDeviceInfoGetOrganizationTagsResponseData } from './IDeviceInfoGetOrganizationTagsMessage';
import { IFrontState } from '../../frontReducers';

const DEVICE_INFO_PREFIX = 'device_info';

type MessageData = IDeviceInfoGetLocationMessage | IDeviceInfoGetOrganizationTagsMessage;
type ResponseData = IDeviceInfoGetLocationResponseData | IDeviceInfoGetOrganizationTagsResponseData | null;

export function handleDeviceInfoMessage(messageTypePrefix: string, { type }: MessageData, state: IFrontState): ResponseData {
	switch (type) {
		case `${messageTypePrefix}.${DEVICE_INFO_PREFIX}.get_location`:
			return { location: state.device.location };
		case `${messageTypePrefix}.${DEVICE_INFO_PREFIX}.get_organization_tags`:
			return { tags: state.device.organizationTags };
		default:
			return null;
	}
}

export default function* deviceInfoHandler({ messageTypePrefix, data, getState }: IHandlerParams): HandlerResult {
	const state = getState();
	return handleDeviceInfoMessage(messageTypePrefix, data, state);
}
