import { posix as path } from 'path';
import { IStorageUnit } from '../NativeDevice/fileSystem';

const surroundingSlash = new RegExp('^/|/$', 'g');

export function trimSlashesAndDots(filePath: string): string {
	filePath = path.normalize(filePath);

	// Remove leading and trailing '/'
	filePath = filePath.replace(surroundingSlash, '');

	if (filePath === '.') {
		return '';
	}

	return filePath;
}

// In this folders append or write actions can still write
const IGNORED_FOLDERS = ['.offline-actions', '.logs'];

// Reserved space by type as percentage
export const RESERVED_SPACE_PERCENTAGE = 10;

/** Test only. */
export function calculateReservedSpace(capacity: number, reservedPercentage: number): number {
	// Round up, so we're on the safe side.
	return Math.ceil((capacity * reservedPercentage) / 100);
}

/** Test only. */
export async function validateFreeSpace(
	storageUnit: IStorageUnit,
	filePath: string,
	fileSizeBytes: number | undefined | null,
): Promise<boolean> {
	if (typeof fileSizeBytes !== 'number') {
		return true;
	}
	// TODO parameterize ignored folders/paths
	if (IGNORED_FOLDERS.some((folder) => filePath === folder || filePath.startsWith(folder + '/'))) {
		return true;
	}
	const remainingSpace = storageUnit.usableSpace - fileSizeBytes;
	return remainingSpace >= 0;
}
