import { Saga, SagaIterator } from 'redux-saga';
import { call } from 'redux-saga/effects';
import { withDependencies } from '../DI/dependencyInjection';
import { OneOrMany } from '../Types/array';
import Responsibility from './Responsibility';

export const whenResponsible = <Args extends unknown[]>(requiredResponsibilities: OneOrMany<Responsibility>, saga: Saga<Args>) =>
	withDependencies(['responsibilities'], function* ({ responsibilities }, ...args: Args): SagaIterator<void> {
		requiredResponsibilities = requiredResponsibilities instanceof Array ? requiredResponsibilities : [requiredResponsibilities];
		if (requiredResponsibilities.every((responsibility) => responsibilities.has(responsibility))) {
			yield call(saga, ...args);
		}
	});
