import IBasicDriver from '../../NativeDevice/IBasicDriver';
import { bindAndTakeEvery } from '../../Socket/socketActionCreator';
import { AuthenticationSucceed } from '@signageos/actions/dist/Authentication/authenticationActions';
import { put } from 'redux-saga/effects';
import { CheckVerification } from '@signageos/actions/dist/Device/Verification/deviceVerificationActions';

export function* deviceVerification(getNativeDriver: () => IBasicDriver) {
	yield bindAndTakeEvery(AuthenticationSucceed, function* () {
		try {
			const deviceUid: string = yield getNativeDriver().getDeviceUid();
			yield put({
				type: CheckVerification,
				uid: deviceUid,
			} as CheckVerification);
		} catch (error) {
			console.error('deviceVerification failed', error);
		}
	});
}
