import { takeEveryAndBindWhenPlatform } from '../../Socket/socketActionCreator';
import { put, call } from 'redux-saga/effects';
import {
	SetDeviceTimerSettingsSucceeded,
	SetDeviceTimerSettingsFailed,
	SetDeviceTimerSettings,
} from '@signageos/actions/dist/Device/Timer/deviceTimerActions';
import { IProprietaryTimerStorage } from '../../Timer/ITimerStorage';
import { TimerLevel } from '@signageos/common-types/dist/Device/Timer/TimerLevel';
import { whenResponsible } from '../../Feature/responsible';
import Responsibility from '../../Feature/Responsibility';
import { whenFrontCapable } from '../../Feature/capable';
import { FrontCapabilities } from '@signageos/common-types/dist/Device/Capabilities/FrontCapability';
import { withDependencies } from '../../DI/dependencyInjection';

export function* setProprietaryTimerCallback(timerStorage: IProprietaryTimerStorage, action: SetDeviceTimerSettings) {
	if (action.level === TimerLevel.Proprietary) {
		try {
			yield call(setProprietaryTimer, timerStorage, action);
			yield put({
				type: SetDeviceTimerSettingsSucceeded,
				uid: action.uid,
			} as SetDeviceTimerSettingsSucceeded);
		} catch (error) {
			console.error('syncProprietaryTimerSagas', error);
			yield put({
				type: SetDeviceTimerSettingsFailed,
				uid: action.uid,
			} as SetDeviceTimerSettingsFailed);
		}
	}
}

export const syncProprietaryTimerSaga = whenResponsible(
	Responsibility.TIMERS,
	whenFrontCapable(
		FrontCapabilities.TIMERS_PROPRIETARY,
		withDependencies(['proprietaryTimerStorage'], function* ({ proprietaryTimerStorage }) {
			yield takeEveryAndBindWhenPlatform(SetDeviceTimerSettings, setProprietaryTimerCallback, proprietaryTimerStorage);
		}),
	),
);

export async function setProprietaryTimer(timerStorage: IProprietaryTimerStorage, action: SetDeviceTimerSettings) {
	if (action.timeOn === null && action.timeOff === null) {
		await timerStorage.deleteShortTimer(action.timerType);
		return;
	}

	const { timerType: type, timeOn, timeOff, weekdays } = action;

	await timerStorage.setShortTimer({
		type,
		timeOn,
		timeOff,
		weekdays,
	});
}
