import { SagaIterator } from 'redux-saga';
import { call, delay } from 'redux-saga/effects';
import { fetch } from '../../Isomorphic/fetch';
import IBasicDriver from '../../NativeDevice/IBasicDriver';
import IConfig from '../../Display/IConfig';
import { getConfigurationBaseUrl } from '../Configuration/deviceConfigurationHelper';

const CHECK_SERVER_TIME_PERIOD = 10e3;
const MAX_TIMESTAMP_DIFF = 1000 * 3600 * 168; // 1 week

export function* checkServerTimeWhenRequested(
	getNativeDriver: () => IBasicDriver,
	defaultConfig: IConfig,
	checkTimeBeforeConnection: boolean,
	getDeviceTimestamp: () => Promise<number>,
): SagaIterator {
	if (!checkTimeBeforeConnection) {
		return;
	}
	while (true) {
		const configBaseUrl: string = yield call(getConfigurationBaseUrl, getNativeDriver(), defaultConfig);
		const response: Response = yield call(fetch, `${configBaseUrl}/time`);

		const { timestamp: serverTimestamp }: { timestamp: number } = yield call([response, response.json]);
		const deviceTimestamp: number = yield call(getDeviceTimestamp);

		if (Math.abs(deviceTimestamp - serverTimestamp) < MAX_TIMESTAMP_DIFF) {
			return;
		}
		yield delay(CHECK_SERVER_TIME_PERIOD);
	}
}
