import { ConnectDevice, DisconnectDevice } from '@signageos/actions/dist/Device/Connect/deviceConnectActions';
import { bindAndTakeEvery } from '../../Socket/socketActionCreator';
import { injectDependencies } from '../../DI/dependencyInjection';
import { putDeviceConnected } from './deviceConnectActions';

export function* deviceConnectSaga() {
	yield injectDependencies({
		connectedBaseUrl: null,
	});
	yield bindAndTakeEvery(ConnectDevice, function* (action: ConnectDevice) {
		yield injectDependencies({
			connectedBaseUrl: action.remoteIp,
		});
		yield putDeviceConnected(action);
	});
	yield bindAndTakeEvery(DisconnectDevice, function* () {
		yield injectDependencies({
			connectedBaseUrl: null,
		});
	});
}
