import IAction from '@signageos/actions/dist/IAction';
import { ConnectDevice } from '@signageos/actions/dist/Device/Connect/deviceConnectActions';
import { put } from 'redux-saga/effects';

export const DeviceConnected = 'Device.Connect.DeviceConnected';
export interface IDeviceConnected extends IAction<typeof DeviceConnected> {
	appletUid: string;
	appletVersion: string;
}

export function* putDeviceConnected(action: ConnectDevice) {
	yield put<IDeviceConnected>({
		type: DeviceConnected,
		appletUid: action.appletUid,
		appletVersion: action.appletVersion,
	});
}
