import { SagaIterator } from 'redux-saga';
import { put, takeEvery } from 'redux-saga/effects';
import { Container, StaticContainer } from './Container';
import { UpdateDIDependency, RequestDIContainer, UpdateDIContainer } from './dependenciesActions';

export function* dependencyInjection(staticContainer: StaticContainer): SagaIterator {
	let container: Partial<Omit<Container, 'managementDriver'>> = { ...staticContainer };

	yield takeEvery(UpdateDIDependency, function* (action: UpdateDIDependency) {
		container = { ...container, ...action.dependencies };
		yield put<UpdateDIContainer>({
			type: UpdateDIContainer,
			container,
		});
	});
	yield takeEvery(RequestDIContainer, function* (_action: RequestDIContainer) {
		yield put<UpdateDIContainer>({
			type: UpdateDIContainer,
			container,
		});
	});

	yield put<UpdateDIContainer>({
		type: UpdateDIContainer,
		container,
	});
}
