import { Container, DynamicContainer } from './Container';

/**
 * This action is used by other sagas to dynamically fill the DI container.
 * Use the wrapper function `injectDependencies` instead.
 */
export const UpdateDIDependency = 'DI.UpdateDIDependency';
export interface UpdateDIDependency {
	type: typeof UpdateDIDependency;
	dependencies: Partial<DynamicContainer>;
}

/**
 * @protected This action is used only internally by the DI container.
 */
export const RequestDIContainer = 'DI.RequestDIContainer';
export interface RequestDIContainer {
	type: typeof RequestDIContainer;
}

/**
 * @protected This action is used only internally by the DI container.
 */
export const UpdateDIContainer = 'DI.UpdateDIContainer';
export interface UpdateDIContainer {
	type: typeof UpdateDIContainer;
	container: Partial<Container>;
}
