import IManagementDriver, { IFrontManagementDriver } from '../NativeDevice/Management/IManagementDriver';

export const getConfiguration = async (
	config: Record<string, any>,
	encryptedFields: string[],
	managementDriver: IManagementDriver & IFrontManagementDriver,
): Promise<Record<string, any>> => {
	let result: Record<string, any> = {};
	for (const key in config) {
		if (encryptedFields.includes(key)) {
			const jweGeneral = JSON.parse(Buffer.from(config[key], 'base64').toString('utf-8'));
			result[key] = await managementDriver.secretManager.decryptJweGeneralToUtf8(jweGeneral);
		} else {
			result[key] = config[key];
		}
	}

	return result;
};
