import ICacheStorageInfo from './ICacheStorageInfo';

export type IFileContentIndex = { [uid: string]: string };

interface ICache {
	fetchAllUids(): Promise<string[]>;
	fetchAll(): Promise<IFileContentIndex>;
	fetchOne(uid: string): Promise<string>;
	deleteOne(uid: string): Promise<void>;
	saveOne(uid: string, content: string): Promise<void>;
	getStorageInfo(): Promise<ICacheStorageInfo>;
}
export default ICache;
