import AuthenticationFailReason from '@signageos/actions/dist/Authentication/AuthenticationFailReason';
import {
	RevokeDevice,
	RevokeSucceed,
	NewSessionStored,
	AuthenticateDevice,
	AuthenticationSucceed,
	AuthenticationFailed,
} from '@signageos/actions/dist/Authentication/authenticationActions';

export interface IAuthenticationState {
	authenticated: boolean;
	authenticating: boolean;
	failReason: AuthenticationFailReason | null;
	revoking: boolean;
}

const initialState: IAuthenticationState = {
	authenticated: false,
	authenticating: false,
	failReason: null,
	revoking: false,
};

export function authentication(
	state: IAuthenticationState = initialState,
	action: AuthenticateDevice | AuthenticationSucceed | AuthenticationFailed | NewSessionStored | RevokeDevice | RevokeSucceed,
) {
	switch (action.type) {
		case AuthenticateDevice:
			return {
				...state,
				authenticating: true,
				failReason: null,
			};
		case AuthenticationSucceed:
			return {
				...state,
				authenticated: true,
				authenticating: false,
				failReason: null,
			};
		case NewSessionStored:
			return {
				...state,
				authenticated: true,
			};
		case AuthenticationFailed:
			return {
				...state,
				authenticating: false,
				failReason: action.reason,
			};
		case RevokeDevice:
			return {
				...state,
				revoking: true,
			};
		case RevokeSucceed:
			return {
				...state,
				authenticated: false,
				revoking: false,
			};
		default:
			return state;
	}
}
