import { Store, Action, Dispatch, Middleware } from 'redux';
import { defineInvisibleProperty } from '../Object/property';
import { EventEmitter } from 'events';

export const actionEmitterMiddleware: Middleware =
	<TState1>(_store: Store<TState1>) =>
	<TState>(next: Dispatch<TState>) =>
	<TAction extends Action>(action: TAction): TAction => {
		defineInvisibleProperty(action, '__emitter', new EventEmitter());
		return next(action);
	};

export type ActionForwardMiddleware = (emitter: EventEmitter) => Middleware;
export const createActionForwardMiddleware: ActionForwardMiddleware =
	(emitter: EventEmitter) =>
	<TState1>(_store: Store<TState1>) =>
	<TState>(next: Dispatch<TState>) =>
	<TAction extends Action>(action: TAction): TAction => {
		emitter.emit(action.type, action);
		return next(action);
	};
