import * as runtime from '../../../lib/runtime.js';
const { BaseAPI } = runtime;
/**
 *
 */
export class AttackProtectionManager extends BaseAPI {
    /**
     * Get breached password detection settings
     *
     * @throws {RequiredError}
     */
    async getBreachedPasswordDetectionConfig(initOverrides) {
        const response = await this.request({
            path: `/attack-protection/breached-password-detection`,
            method: 'GET',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Get the brute force configuration
     *
     * @throws {RequiredError}
     */
    async getBruteForceConfig(initOverrides) {
        const response = await this.request({
            path: `/attack-protection/brute-force-protection`,
            method: 'GET',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Get the suspicious IP throttling configuration
     *
     * @throws {RequiredError}
     */
    async getSuspiciousIpThrottlingConfig(initOverrides) {
        const response = await this.request({
            path: `/attack-protection/suspicious-ip-throttling`,
            method: 'GET',
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Update breached password detection settings
     *
     * @throws {RequiredError}
     */
    async updateBreachedPasswordDetectionConfig(bodyParameters, initOverrides) {
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/attack-protection/breached-password-detection`,
            method: 'PATCH',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Update the brute force configuration
     *
     * @throws {RequiredError}
     */
    async updateBruteForceConfig(bodyParameters, initOverrides) {
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/attack-protection/brute-force-protection`,
            method: 'PATCH',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
    /**
     * Update the suspicious IP throttling configuration
     *
     * @throws {RequiredError}
     */
    async updateSuspiciousIpThrottlingConfig(bodyParameters, initOverrides) {
        const headerParameters = {};
        headerParameters['Content-Type'] = 'application/json';
        const response = await this.request({
            path: `/attack-protection/suspicious-ip-throttling`,
            method: 'PATCH',
            headers: headerParameters,
            body: bodyParameters,
        }, initOverrides);
        return runtime.JSONApiResponse.fromResponse(response);
    }
}
//# sourceMappingURL=attack-protection-manager.js.map