"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.TokenProviderMiddleware = void 0;
const token_provider_js_1 = require("./token-provider.js");
class TokenProviderMiddleware {
    constructor(options) {
        var _a;
        if ('token' in options) {
            this.tokenProvider = {
                getAccessToken: () => Promise.resolve(options.token),
            };
        }
        else {
            this.tokenProvider = new token_provider_js_1.TokenProvider({
                ...options,
                audience: (_a = options.audience) !== null && _a !== void 0 ? _a : `https://${options.domain}/api/v2/`,
                ...{ clientSecret: options.clientSecret },
                ...{
                    clientAssertionSigningKey: options
                        .clientAssertionSigningKey,
                },
            });
        }
    }
    async pre(context) {
        const token = await this.tokenProvider.getAccessToken();
        context.init.headers = {
            ...context.init.headers,
            Authorization: `Bearer ${token}`,
        };
        return {
            url: context.url,
            init: context.init,
        };
    }
}
exports.TokenProviderMiddleware = TokenProviderMiddleware;
//# sourceMappingURL=token-provider-middleware.js.map