"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.default = createSocket;
const socket_io_client_1 = __importDefault(require("socket.io-client"));
const url = __importStar(require("url"));
function createSocket(socketUri, onConnected, onDisconnected, onError) {
    const parsedSocketUrl = url.parse(socketUri);
    const pathname = parsedSocketUrl.pathname;
    const socketUrl = parsedSocketUrl.protocol + '//' + parsedSocketUrl.host;
    const socketIoPath = (pathname + '/socket.io').replace(/\/+/g, '/');
    const socket = (0, socket_io_client_1.default)(socketUrl, {
        path: socketIoPath,
        forceNew: true,
        upgrade: false,
        rememberUpgrade: true,
        transports: ['websocket'],
        reconnection: false,
        timeout: 5e3,
    });
    socket.on('connect_error', (error) => onError(error));
    socket.on('error', (error) => onError(error));
    socket.on('connection', () => onConnected());
    socket.on('disconnect', () => onDisconnected());
    return {
        on(event, listener) {
            socket.on(event, (message, callback) => {
                listener(message);
                if (callback) {
                    callback();
                }
            });
        },
        once(event, listener) {
            socket.once(event, (message, callback) => {
                listener(message);
                if (callback) {
                    callback();
                }
            });
        },
        emit(event, message, callback) {
            socket.emit(event, message, callback);
        },
        removeListener(event, listener) {
            socket.off(event, listener);
        },
        removeAllListeners() {
            socket.removeAllListeners();
        },
        close() {
            socket.close();
        },
    };
}
//# sourceMappingURL=createSocketIOSocket.js.map