/**
 * Rename a property in a type.
 * E.g.:
 * ```ts
 * type A = { a: string; b: number; };
 * type B = RenameProperty<A, 'a', 'c'>;
 * // B is { c: string; b: number; }
 * ```
 */
export type RenameProperty<T, K extends keyof T, N extends string> = Omit<T, K> & {
    [RenamedK in N]: T[K];
};
