"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.stopService = void 0;
exports.handleSignals = handleSignals;
exports.suppressUncaughtExceptionsAndUnhandledRejections = suppressUncaughtExceptionsAndUnhandledRejections;
const generator_1 = require("../Hash/generator");
process.uid = (0, generator_1.generateUniqueHash)();
const stopService = (service) => __awaiter(void 0, void 0, void 0, function* () {
    process.removeAllListeners('SIGTERM');
    process.removeAllListeners('SIGINT');
    yield service.stop();
    process.exit(0);
});
exports.stopService = stopService;
function handleSignals(service) {
    const onSignalLogAndExit = (signal) => {
        process.on(signal, () => __awaiter(this, void 0, void 0, function* () {
            console.info(`Received signal ${signal}`);
            yield (0, exports.stopService)(service);
        }));
    };
    onSignalLogAndExit('SIGTERM');
    onSignalLogAndExit('SIGINT');
}
function suppressUncaughtExceptionsAndUnhandledRejections() {
    process.removeAllListeners('uncaughtException');
    process.removeAllListeners('unhandledRejection');
    process.on('uncaughtException', (error) => {
        console.error(error && error.stack ? error.stack : error);
    });
    process.on('unhandledRejection', (error) => {
        console.error(error && error.stack ? error.stack : error);
    });
}
//# sourceMappingURL=process.js.map