"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.routeStatus = routeStatus;
const createHttpStatusMiddleware_1 = __importDefault(require("../../../../HttpStatus/createHttpStatusMiddleware"));
const amqpStatus_1 = require("../../../../HttpStatus/statuses/amqpStatus");
const postgreStatus_1 = require("../../../../HttpStatus/statuses/postgreStatus");
const redisStatus_1 = require("../../../../HttpStatus/statuses/redisStatus");
const mongoStatus_1 = require("../../../../HttpStatus/statuses/mongoStatus");
/**
 * Serves some basic human-readable information about the service
 */
function routeStatus({ router, service, connections }) {
    const statuses = [];
    if (connections === null || connections === void 0 ? void 0 : connections.amqp) {
        const amqpConnections = Object.values(connections.amqp);
        statuses.push((0, amqpStatus_1.amqpStatus)(amqpConnections, service.uid));
    }
    if (connections === null || connections === void 0 ? void 0 : connections.postgres) {
        const postgresConnections = Object.values(connections.postgres);
        statuses.push((0, postgreStatus_1.postgreStatus)(postgresConnections, service.uid));
    }
    if (connections === null || connections === void 0 ? void 0 : connections.redis) {
        const redisConnections = Object.values(connections.redis);
        statuses.push((0, redisStatus_1.redisStatus)(redisConnections, service.uid));
    }
    if (connections === null || connections === void 0 ? void 0 : connections.mongodb) {
        const mongodbConnections = Object.values(connections.mongodb);
        statuses.push((0, mongoStatus_1.mongoStatus)(mongodbConnections, service.uid));
    }
    router.get('/status', (0, createHttpStatusMiddleware_1.default)({
        namespace: service.name,
        uniqueId: service.uid,
        // TODO expose from library
        // additionalDataCallback: (_req: Request) => {
        // },
    }, ...statuses));
}
//# sourceMappingURL=status.js.map