"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createHttpServer = createHttpServer;
const app_1 = require("./express/app");
const monitoring_1 = require("./express/monitoring");
const serverFactory_1 = require("./server/serverFactory");
/**
 * Creates a HTTP server
 *
 * Serves some routes out of the box, that are common for all services:
 *   /         HTML index page with company logo
 *   /status   Returns some basic human-readable information about the service
 *   /ready    Responds with 200 if service is ready to serve requests,
 *              typically used by Kubernetes readiness probe
 *   /metrics  Metrics endpoint for Prometheus
 *
 * This factory returns a router, that can be used to add more routes.
 */
function createHttpServer({ service, port, monitoringPort, metricsClient, connections, isReady, isAlive, accessLogCallback, noRouteIndex, }) {
    const appExpress = (0, app_1.createAppExpress)({ service, metricsClient, connections, accessLogCallback, noRouteIndex });
    const monitoringExpress = (0, monitoring_1.createMonitoringExpress)({ metricsClient, isReady, isAlive });
    const appServer = (0, serverFactory_1.createServer)(appExpress, port);
    const monitoringServer = (0, serverFactory_1.createServer)(monitoringExpress, monitoringPort);
    return {
        server: appServer.server,
        express: appExpress,
        monitoringServer: monitoringServer.server,
        monitoringExpress: monitoringExpress,
        listen() {
            return __awaiter(this, void 0, void 0, function* () {
                metricsClient.init();
                yield Promise.all([appServer.listen(), monitoringServer.listen()]);
                console.info('Server running on server port ' + port);
            });
        },
        close() {
            return __awaiter(this, void 0, void 0, function* () {
                yield Promise.all([appServer.close(), monitoringServer.close()]);
                metricsClient.clear();
            });
        },
    };
}
//# sourceMappingURL=httpServerFactory.js.map