"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.copyRecursively = copyRecursively;
const path = __importStar(require("path"));
const rsync_1 = __importDefault(require("rsync"));
const child_process_1 = require("child_process");
function copyRecursively(sourcePath, remoteDestinationPath, shell) {
    return __awaiter(this, void 0, void 0, function* () {
        const [destinationHost, destinationPath] = remoteDestinationPath.indexOf(':') !== -1 ? remoteDestinationPath.split(':') : [undefined, remoteDestinationPath];
        const ensureDirProcess = (0, child_process_1.spawn)(shell || 'sh', [
            ...(destinationHost ? [destinationHost] : []),
            'mkdir',
            '-p',
            path.dirname(destinationPath),
        ]);
        yield executeProcess(ensureDirProcess);
        const copyFileRsync = new rsync_1.default().flags('pt').source(sourcePath).destination(remoteDestinationPath);
        if (shell) {
            copyFileRsync.shell(shell);
        }
        yield executeRsync(copyFileRsync);
    });
}
function executeRsync(rsync) {
    return new Promise((resolve, reject) => {
        rsync.execute((error) => {
            if (error) {
                reject(error);
            }
            else {
                resolve();
            }
        });
    });
}
function executeProcess(childProcess) {
    return new Promise((resolve, reject) => {
        childProcess.on('close', (_code) => resolve());
        childProcess.on('error', (error) => reject(error));
    });
}
//# sourceMappingURL=copier.js.map