"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.retryAsyncUntil = exports.PredicateNotMetError = exports.retryAsync = void 0;
const progressiveWait_1 = require("../Timer/progressiveWait");
/**
 * Repeatedly try to call the callback function until it successfully resolves
 * or the number of attempts reaches the passed count of attempts.
 * Throws an error otherwise.
 */
const retryAsync = (count_1, callback_1, ...args_1) => __awaiter(void 0, [count_1, callback_1, ...args_1], void 0, function* (count, callback, progressiveWait = (0, progressiveWait_1.createProgressiveWait)(500)) {
    try {
        return yield callback();
    }
    catch (e) {
        if (count === 1) {
            throw e;
        }
        yield progressiveWait.wait();
        return yield (0, exports.retryAsync)(--count, callback, progressiveWait);
    }
});
exports.retryAsync = retryAsync;
class PredicateNotMetError extends Error {
    constructor(message) {
        super(message);
        Object.setPrototypeOf(this, PredicateNotMetError.prototype);
    }
}
exports.PredicateNotMetError = PredicateNotMetError;
/**
 * Repeatedly try to call the callback function until the passed predicate function returns true
 * or the number of attempts reaches the passed count of attempts.
 * Throws an error otherwise.
 */
const retryAsyncUntil = (_a) => __awaiter(void 0, [_a], void 0, function* ({ callback, predicate, progressiveWait = (0, progressiveWait_1.createProgressiveWait)(500), count = 10, attemptErrorLog, }) {
    try {
        if (count === 0) {
            throw new PredicateNotMetError(`Predicate not met after specified number of attempts.`);
        }
        const payload = yield callback();
        if (predicate(payload)) {
            return payload;
        }
        yield progressiveWait.wait();
        return yield (0, exports.retryAsyncUntil)({ callback, predicate, progressiveWait, count: --count, attemptErrorLog });
    }
    catch (e) {
        if (attemptErrorLog !== undefined && e instanceof Error) {
            attemptErrorLog(e);
        }
        if (e instanceof PredicateNotMetError) {
            throw e;
        }
        yield progressiveWait.wait();
        return yield (0, exports.retryAsyncUntil)({ callback, predicate, progressiveWait, count: --count, attemptErrorLog });
    }
});
exports.retryAsyncUntil = retryAsyncUntil;
//# sourceMappingURL=retry.js.map