"use strict";
var __await = (this && this.__await) || function (v) { return this instanceof __await ? (this.v = v, this) : new __await(v); }
var __asyncGenerator = (this && this.__asyncGenerator) || function (thisArg, _arguments, generator) {
    if (!Symbol.asyncIterator) throw new TypeError("Symbol.asyncIterator is not defined.");
    var g = generator.apply(thisArg, _arguments || []), i, q = [];
    return i = {}, verb("next"), verb("throw"), verb("return", awaitReturn), i[Symbol.asyncIterator] = function () { return this; }, i;
    function awaitReturn(f) { return function (v) { return Promise.resolve(v).then(f, reject); }; }
    function verb(n, f) { if (g[n]) { i[n] = function (v) { return new Promise(function (a, b) { q.push([n, v, a, b]) > 1 || resume(n, v); }); }; if (f) i[n] = f(i[n]); } }
    function resume(n, v) { try { step(g[n](v)); } catch (e) { settle(q[0][3], e); } }
    function step(r) { r.value instanceof __await ? Promise.resolve(r.value.v).then(fulfill, reject) : settle(q[0][2], r); }
    function fulfill(value) { resume("next", value); }
    function reject(value) { resume("throw", value); }
    function settle(f, v) { if (f(v), q.shift(), q.length) resume(q[0][0], q[0][1]); }
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createDeferredStream = void 0;
const lock_1 = require("./lock");
/**
 * It creates outside controlled promise/async iterator, similar to createDeferred, but may be more than once.
 * It does not guarantee that every resolved value is awaited and it only holds the current one.
 * Similar to Promise.withResolvers(), but throws when resolved multiple times.
 */
const createDeferredStream = () => {
    let updated = (0, lock_1.createLock)();
    let state = [false, undefined];
    const resolveState = () => {
        if (state[0]) {
            if (state[1][0]) {
                return Promise.resolve(state[1][1]);
            }
            else {
                return Promise.reject(state[1][1]);
            }
        }
    };
    return {
        get promise() {
            const resolved = resolveState();
            if (resolved) {
                return resolved;
            }
            return updated.promise.then(() => resolveState()); // non-null assertion is fine because it is guaranteed that state has value, after updated resolves
        },
        get value() {
            if (state[0] && state[1][0]) {
                return state[1][1];
            }
        },
        resolve: (value) => {
            state = [true, [true, value]];
            updated.release();
            updated = (0, lock_1.createLock)();
        },
        reject: (error) => {
            state = [true, [false, error]];
            updated.release();
            updated = (0, lock_1.createLock)();
        },
        iterator: function () {
            return __asyncGenerator(this, arguments, function* () {
                while (true) {
                    const value = yield __await(this.promise); // wait until a value is resolvable (this is not immediately resolved only for the first value)
                    const waitForUpdatePromise = updated.promise; // save the current update lock, before pausing execution with yield
                    yield yield __await(value); // yield the resolved value and pause iterator
                    yield __await(waitForUpdatePromise); // wait until the a new value is resolved
                }
            });
        },
    };
};
exports.createDeferredStream = createDeferredStream;
//# sourceMappingURL=deferredStream.js.map