export interface NpmCredentials {
    host?: string;
    url?: string;
    authToken?: string;
}
export type NpmCredentialsProvider = () => Promise<NpmCredentials>;
/**
 * Uses credentials from environment variables, if present
 */
export declare function createDefaultNpmCredentialsProvider(): NpmCredentialsProvider;
export declare function createStaticNpmCredentialsProvider(credentials: NpmCredentials): NpmCredentialsProvider;
export declare function createAwsNpmCredentialsProvider({ domain, domainOwner, repository, region, }: {
    domain: string;
    domainOwner: string;
    repository: string;
    /** By default will use contents of env variable AWS_PROFILE */
    region?: string;
}): NpmCredentialsProvider;
