import { Readable } from 'stream';
export interface UploadFileArgs {
    /** Path to local file */
    filePath: string;
    /** Destination bucket to upload the file to */
    bucket: string;
    /** Path in the bucket to upload the file to */
    remotePath: string;
    /**
     * A standard MIME type describing the format of the contents
     * @see https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type
     */
    contentType?: string;
}
export interface UploadContentArgs {
    /** Content of the file to upload */
    content: string;
    /** Destination bucket to upload the file to */
    bucket: string;
    /** Path in the bucket to upload the file to */
    remotePath: string;
    /**
     * A standard MIME type describing the format of the contents
     * @see https://www.rfc-editor.org/rfc/rfc9110.html#name-content-type
     */
    contentType?: string;
}
export interface DownloadFileArgs {
    bucket: string;
    remotePath: string;
    filePath: string;
}
export interface ListFilesArgs {
    bucket: string;
    remotePath: string;
    maxKeys?: number;
    startAfterKey?: string;
}
export interface GetMetadataArgs {
    bucket: string;
    remotePath: string;
}
export interface DeleteFileArgs {
    bucket: string;
    remotePath: string;
}
export interface UploadStreamArgs {
    bucket: string;
    remotePath: string;
    stream: Readable;
}
export interface BucketExistsArgs {
    bucket: string;
}
export interface CreateBucketArgs {
    bucket: string | undefined;
}
export interface CreateBucketResponse {
    Location?: string;
}
export interface DeleteBucketArgs {
    bucket: string | undefined;
}
export interface PutBucketPolicyArgs {
    bucket: string | undefined;
    policy: string | undefined;
}
export interface HeadObject {
    AcceptRanges?: string;
    LastModified?: Date;
    ContentLength?: number;
    ETag?: string;
    ContentType?: string;
    Metadata?: Record<string, string>;
    StorageClass?: string;
}
export interface GetObjectArgs {
    bucket: string | undefined;
    key: string | undefined;
}
export interface GetObjectResponse {
    Body?: Readable;
    ContentType?: string;
}
export interface DeleteObjectArgs {
    bucket: string | undefined;
    key: string | undefined;
}
export interface GetPresignedUrlArgs {
    /** The bucket the signed URL belongs to */
    bucket: string;
    /** The key of the object the signed URL belongs to */
    remotePath: string;
    /** The expiration time of the signed URL in seconds */
    expirationInSec: number;
}
