"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.enqueueMessageRetryable = enqueueMessageRetryable;
exports.enqueueMessage = enqueueMessage;
const wait_1 = __importDefault(require("../Timer/wait"));
const queueConfigurator_1 = require("./queueConfigurator");
const debug_1 = __importDefault(require("debug"));
const debug = (0, debug_1.default)('@signageos/lib:AMQP:enqueueMessage');
function enqueueMessageRetryable(amqpConnection_1, queueName_1, message_1) {
    return __awaiter(this, arguments, void 0, function* (amqpConnection, queueName, message, options = {}, numberOfRetrying = -1, delayBeforeRetry = 500) {
        try {
            yield enqueueMessage(amqpConnection, queueName, message, options);
        }
        catch (error) {
            if (numberOfRetrying !== 0) {
                debug(`Enqueue message failed. Retry after ${delayBeforeRetry} ms`);
                yield (0, wait_1.default)(delayBeforeRetry);
                yield enqueueMessageRetryable(amqpConnection, queueName, message, options, numberOfRetrying - 1, delayBeforeRetry * 2);
            }
            else {
                throw error;
            }
        }
    });
}
function enqueueMessage(amqpConnection_1, queueName_1, message_1) {
    return __awaiter(this, arguments, void 0, function* (amqpConnection, queueName, message, options = {}) {
        const connection = yield amqpConnection.pool.acquire(options.priority);
        try {
            const channel = yield connection.createConfirmChannel();
            yield (0, queueConfigurator_1.assertRejectableQueue)(channel, queueName, options.maxPriority);
            yield new Promise((resolve, reject) => channel.sendToQueue(queueName, new Buffer(JSON.stringify(message)), { persistent: true }, (error) => error !== null ? reject(error) : resolve()));
            yield amqpConnection.pool.release(connection);
        }
        catch (error) {
            yield amqpConnection.pool.destroy(connection);
            throw error;
        }
    });
}
//# sourceMappingURL=enqueueMessage.js.map