"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createExpressApp = createExpressApp;
var express_1 = __importDefault(require("express"));
var qs_1 = __importDefault(require("qs"));
/**
 * Create an instance of an Express application and apply common middleware
 */
function createExpressApp() {
    var app = (0, express_1.default)();
    // Parses query string, converting comma separated values into arrays
    // should be defined before any other middleware due to known issue in versions before 5
    // see more: https://github.com/expressjs/express/issues/3454
    app.set('query parser', function (rawQueryString) {
        return qs_1.default.parse(rawQueryString, { comma: true });
    });
    return app;
}
//# sourceMappingURL=expressFactory.js.map