import mongoose from 'mongoose';
import * as mongodb from 'mongodb';
import { MongoDBDriverExporter } from '../Metrics/mongoDBDriverExporter';
export interface IMongodbConnection {
    connection: mongoose.Connection | null;
    session?: mongodb.ClientSession;
    connect: () => Promise<void>;
    close: () => Promise<void>;
    /**
     * Start monitoring the connection and report metrics to the metricsClient
     *
     * @exporter - metrics exporter
     * @connectionName - name of the connection that will be used as a label to distinguish between different connections
     */
    monitor: (exporter: MongoDBDriverExporter, connectionName: string) => void;
}
/**
 * @deprecated use MongoDBConnection class directly
 */
export declare function createMongodbConnection(mongoDbDsn: string, options?: mongoose.ConnectOptions, onExit?: () => void): IMongodbConnection;
