export interface ICommandPayload<TCommandType extends string = string> {
    type: TCommandType;
}
/**
 * Command is a representation of a single command that should be executed in the system.
 * It's a wrapper interface for the command payload.
 * It contains all the necessary metadata for the command.
 * This command is mostly used for command query responsibility segregation (CQRS).
 */
interface ICommand<TPayload extends ICommandPayload<string>> {
    /**
     * Unique identifier of the command.
     */
    id: string;
    /**
     * Type of the command.
     * It should be always the same as {@link ICommandPayload['type']}.
     */
    type: TPayload['type'];
    /**
     * Identifier of the source of the command.
     * It's usually used for logging and debugging.
     * It can be used in some cases to identify the source of the command
     * and to check if the event was dispatched by the same source as the command.
     */
    sourceUid: string;
    /**
     * Date when the command was dispatched.
     */
    receivedAt: Date;
    /**
     * Payload of the command.
     * The only required field is the `type` field.
     * The `type` field should always be the same as the `type` field of the command.
     */
    payload: TPayload;
}
export default ICommand;
