import { getGroupedChangeLog } from '../src/helper';
import should from 'should';

describe('helper', () => {
	describe('getGroupedChangeLog', () => {
		it('should parse simple changelog', () => {
			const changelog = `
      ## [16.1.1] - 2024-06-21
      ### Fixed
      - \`Auth0AuthenticationClient.login\` was failing if no scope was provided

      ## [16.1.0] - 2024-06-20
      ### Added
      - \`AmqpEventConsumer\` logs consumed events to stdout

      ## [16.0.0] - 2024-06-18
      ### Removed
      - Package \`@swc/core\` is not installed automatically because it using too much disk space (install it as a peer dependency instead)

      ## [15.7.2] - 2024-06-11
      ### Fixed
      - The getNextTimerEvent function returns correct timer type according to the provided argument

      ## [15.7.1] - 2024-06-05
      ### Fixed
      - Upgraded Auth0 dependency to v4.3.1, upgraded Express

      ## [15.7.0] - 2024-05-28
      ### Added
      - New type \`RenameProperty\`
      - Pretty printed JSON log format to Winston logger
      ### Fixed
      - TypeError: Do not know how to serialize a BigInt on Debug mongo events

      ## [15.6.0] - 2024-05-21
      ### Added
      - Function \`expectType\` for TypeScript testing types
      `;

			const grouped = getGroupedChangeLog(changelog);

			should(grouped).deepEqual({
				'16.1.1': {
					Fixed: ['`Auth0AuthenticationClient.login` was failing if no scope was provided'],
				},
				'16.1.0': { Added: ['`AmqpEventConsumer` logs consumed events to stdout'] },
				'16.0.0': {
					Removed: [
						'Package `@swc/core` is not installed automatically because it using too much disk space (install it as a peer dependency instead)',
					],
				},
				'15.7.2': {
					Fixed: ['The getNextTimerEvent function returns correct timer type according to the provided argument'],
				},
				'15.7.1': {
					Fixed: ['Upgraded Auth0 dependency to v4.3.1, upgraded Express'],
				},
				'15.7.0': {
					Added: ['New type `RenameProperty`', 'Pretty printed JSON log format to Winston logger'],
					Fixed: ['TypeError: Do not know how to serialize a BigInt on Debug mongo events'],
				},
				'15.6.0': { Added: ['Function `expectType` for TypeScript testing types'] },
			});
		});
	});
});
