import { promises as fs } from 'fs';

export const readJSON = (path: string) => fs.readFile(path).then((b) => JSON.parse(b.toString()));

export const transformFile = (path: string, map: (contents: string) => string) =>
	fs
		.readFile(path)
		.then((b) => b.toString())
		.then(map)
		.then((contents) => fs.writeFile(path, contents));
