import { allChangelogEntries, ChangeLogEntry } from './ChangeLogEntry';
import { getPipedInput, getGroupedChangeLog } from './helper';

(async function () {
	const changeLog = await getPipedInput();
	const groupedLog = getGroupedChangeLog(changeLog);
	const changedTypes = Object.keys(groupedLog.Unreleased || {}) as ChangeLogEntry[];
	switch (true) {
		case changedTypes.indexOf(ChangeLogEntry.Changed) !== -1:
		case changedTypes.indexOf(ChangeLogEntry.Removed) !== -1:
			process.stdout.write('major');
			break;
		case changedTypes.indexOf(ChangeLogEntry.Added) !== -1:
			process.stdout.write('minor');
			break;
		case changedTypes.indexOf(ChangeLogEntry.Fixed) !== -1:
		case changedTypes.indexOf(ChangeLogEntry.Security) !== -1:
		case changedTypes.indexOf(ChangeLogEntry.Deprecated) !== -1:
			process.stdout.write('patch');
			break;
		case changedTypes.length === 0:
			process.stdout.write('patch');
			break;
		default:
			throw new Error(
				`Unknown type of change: ${changedTypes.join(', ')} Only following values are allowed: ${allChangelogEntries.join(', ')}`,
			);
	}
})();

process.on('unhandledRejection', (error) => {
	throw error;
});
