#!/usr/bin/env node
// @ts-check
import { readJSON } from './utils.js';

(async () => {
	const packagePath = process.cwd() + '/package.json';
	const pkg = await readJSON(packagePath);

	const dependencies: Record<string, string> = pkg.dependencies || {};
	const devDependencies: Record<string, string> = pkg.devDependencies || {};

	const whitelist = ['@signageos/codestyle'];
	const packages = Object.keys(dependencies).concat(Object.keys(devDependencies));

	let forbiddenPackages = packages.filter((p) => p.match('@signageos/*'));
	forbiddenPackages = forbiddenPackages.filter((p) => !whitelist.includes(p));

	if (forbiddenPackages.length > 0) {
		console.error(`    Forbidden packages ${forbiddenPackages.join(', ')} found in package.json. 
@signageos/* modules can't be used as dependencies because they are private while this module is public and may only use public dependencies.
Only exceptions are whitelisted dependencies: ${whitelist.join(', ')}
`);
		process.exit(1);
	}
})();
