"use strict";
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var import_fs = require("fs");
var import_helper = require("./helper");
(() => __async(exports, null, function* () {
  const packagePath = process.cwd() + "/package.json";
  const packageLockPath = process.cwd() + "/package-lock.json";
  const pkg = yield (0, import_helper.readJSON)(packagePath);
  const packageLock = yield (0, import_helper.readJSON)(packageLockPath).catch(() => null);
  const nextVersion = process.argv[2];
  if (!nextVersion) {
    throw new Error("No version specified");
  }
  pkg.version = nextVersion;
  if (packageLock) {
    packageLock.version = nextVersion;
    if (packageLock.packages && packageLock.packages[""]) {
      packageLock.packages[""].version = nextVersion;
    }
  }
  const indentChar = yield (0, import_helper.detectIndent)(packagePath);
  yield import_fs.promises.writeFile(packagePath, JSON.stringify(pkg, null, indentChar) + "\n");
  if (packageLock) {
    yield import_fs.promises.writeFile(packageLockPath, JSON.stringify(packageLock, null, indentChar) + "\n");
  }
}))();
