"use strict";
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var import_helper = require("./helper");
const version = process.argv[2] || "Unreleased";
const outputType = process.argv[3] || "text";
(function() {
  return __async(this, null, function* () {
    const changeLog = yield (0, import_helper.getPipedInput)();
    const groupedLog = (0, import_helper.getGroupedChangeLog)(changeLog);
    let output;
    if (outputType === "text") {
      const changedTypes = Object.keys(groupedLog[version] || {});
      const releaseNotes = changedTypes.reduce(
        (notes, changeType) => {
          var _a, _b, _c;
          return [...notes, `${changeType}:`, ...(_c = (_b = (_a = groupedLog[version]) == null ? void 0 : _a[changeType]) == null ? void 0 : _b.map((note) => `- ${note}`)) != null ? _c : [], ""];
        },
        []
      );
      output = releaseNotes.join("\n");
    } else if (outputType === "groups") {
      output = typeof groupedLog[version] !== "undefined" ? groupedLog[version] : {};
    }
    process.stdout.write(JSON.stringify(output));
  });
})();
process.on("unhandledRejection", (error) => {
  throw error;
});
