"use strict";
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var import_ChangeLogEntry = require("./ChangeLogEntry");
var import_helper = require("./helper");
(function() {
  return __async(this, null, function* () {
    const changeLog = yield (0, import_helper.getPipedInput)();
    const groupedLog = (0, import_helper.getGroupedChangeLog)(changeLog);
    const changedTypes = Object.keys(groupedLog.Unreleased || {});
    switch (true) {
      case changedTypes.indexOf(import_ChangeLogEntry.ChangeLogEntry.Changed) !== -1:
      case changedTypes.indexOf(import_ChangeLogEntry.ChangeLogEntry.Removed) !== -1:
        process.stdout.write("major");
        break;
      case changedTypes.indexOf(import_ChangeLogEntry.ChangeLogEntry.Added) !== -1:
        process.stdout.write("minor");
        break;
      case changedTypes.indexOf(import_ChangeLogEntry.ChangeLogEntry.Fixed) !== -1:
      case changedTypes.indexOf(import_ChangeLogEntry.ChangeLogEntry.Security) !== -1:
      case changedTypes.indexOf(import_ChangeLogEntry.ChangeLogEntry.Deprecated) !== -1:
        process.stdout.write("patch");
        break;
      case changedTypes.length === 0:
        process.stdout.write("patch");
        break;
      default:
        throw new Error(
          `Unknown type of change: ${changedTypes.join(", ")} Only following values are allowed: ${import_ChangeLogEntry.allChangelogEntries.join(", ")}`
        );
    }
  });
})();
process.on("unhandledRejection", (error) => {
  throw error;
});
