#!/usr/bin/env node
"use strict";
var __async = (__this, __arguments, generator) => {
  return new Promise((resolve, reject) => {
    var fulfilled = (value) => {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    };
    var rejected = (value) => {
      try {
        step(generator.throw(value));
      } catch (e) {
        reject(e);
      }
    };
    var step = (x) => x.done ? resolve(x.value) : Promise.resolve(x.value).then(fulfilled, rejected);
    step((generator = generator.apply(__this, __arguments)).next());
  });
};
var import_utils = require("./utils.js");
(() => __async(exports, null, function* () {
  const packagePath = process.cwd() + "/package.json";
  const pkg = yield (0, import_utils.readJSON)(packagePath);
  const dependencies = pkg.dependencies || {};
  const devDependencies = pkg.devDependencies || {};
  const whitelist = ["@signageos/codestyle"];
  const packages = Object.keys(dependencies).concat(Object.keys(devDependencies));
  let forbiddenPackages = packages.filter((p) => p.match("@signageos/*"));
  forbiddenPackages = forbiddenPackages.filter((p) => !whitelist.includes(p));
  if (forbiddenPackages.length > 0) {
    console.error(`    Forbidden packages ${forbiddenPackages.join(", ")} found in package.json. 
@signageos/* modules can't be used as dependencies because they are private while this module is public and may only use public dependencies.
Only exceptions are whitelisted dependencies: ${whitelist.join(", ")}
`);
    process.exit(1);
  }
}))();
