"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateUid = exports.UID_CHARACTERS = exports.UID_LENGTH = void 0;
const nanoid_1 = require("nanoid");
exports.UID_LENGTH = 36;
exports.UID_CHARACTERS = '0123456789abcdef';
/**
 * Generate a globally unique UID.
 *
 * Generated UIDs are 36 characters long and consist of the characters '0123456789abcdef'.
 * This is the format approved for use across the entire platform, for all entities.
 *
 * UID is generated using library `nanoid`
 * @see https://www.npmjs.com/package/nanoid
 */
exports.generateUid = (0, nanoid_1.customAlphabet)(exports.UID_CHARACTERS, exports.UID_LENGTH);
