"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.DeviceFilterSchema = exports.TagUidsArray = void 0;
const zod_1 = require("zod");
exports.TagUidsArray = zod_1.z.array(zod_1.z.string());
/**
 * This schema is common for DeviceFilter itself and for its `orFilter` property.
 */
const CommonDeviceFilterSchema = zod_1.z.strictObject({
    tagUids: exports.TagUidsArray.optional(),
    /**
     * Each array inside array should represent group of tag and its children.
     * This argument allows to include all devices that have at least one tag from each family tree.
     */
    tagWithChildrenUidGroups: zod_1.z.array(exports.TagUidsArray).optional(),
    locationUids: zod_1.z.array(zod_1.z.string()).optional(),
});
exports.DeviceFilterSchema = zod_1.z
    .strictObject({
    /** @deprecated use identityHashes property instead */
    identityHash: zod_1.z.string().optional(),
    identityHashes: zod_1.z.array(zod_1.z.string()).optional(),
    identityHashesExclude: zod_1.z.array(zod_1.z.string()).optional(),
    uids: zod_1.z.array(zod_1.z.string()).optional(),
    uidsExclude: zod_1.z.array(zod_1.z.string()).optional(),
    accountId: zod_1.z.number().optional(),
    organizationUid: zod_1.z.string().optional(),
    /** @deprecated use applicationTypes property instead */
    applicationType: zod_1.z.string().optional(),
    applicationTypes: zod_1.z.array(zod_1.z.string()).optional(),
    applicationTypeNotEqual: zod_1.z.string().optional(),
    model: zod_1.z.string().optional(),
    brands: zod_1.z.array(zod_1.z.string()).optional(),
    firmwareVersion: zod_1.z.string().optional(),
    firmwareType: zod_1.z.string().optional(),
    search: zod_1.z.string().optional(),
    serialNumber: zod_1.z.string().optional(),
    /** @deprecated use deviceConfigurationModel entity instead */
    bannedSince: zod_1.z.date().optional(),
    policyUids: zod_1.z.array(zod_1.z.string()).optional(),
    createdSince: zod_1.z.date().optional(),
    createdUntil: zod_1.z.date().optional(),
    filterModelName: zod_1.z.string().optional(),
    appletUids: zod_1.z.array(zod_1.z.string()).optional(),
    activeAppletVersion: zod_1.z.string().optional(),
    osVersions: zod_1.z.array(zod_1.z.string()).optional(),
    /** This filter is performed as a logical OR operation of respective fields */
    orFilter: CommonDeviceFilterSchema.optional(),
    hasPolicy: zod_1.z.boolean().optional(),
})
    .extend(CommonDeviceFilterSchema.shape);
