"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidProxyUriSettings = exports.InvalidProxyEnabledSettings = exports.validKeys = void 0;
exports.default = validateProxySettings;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    enabled: true,
    uri: true,
};
function validateProxySettings(settings) {
    var _a;
    const { enabled, uri } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notEnabledValid = !(typeof enabled === 'boolean');
    const notUriValid = !(uri === null || typeof uri === 'string');
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notEnabledValid) {
        validation.addError(new InvalidProxyEnabledSettings(enabled));
    }
    if (notUriValid) {
        validation.addError(new InvalidProxyUriSettings(uri));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidProxyEnabledSettings extends Error {
    constructor(enabled) {
        super(`Proxy Enabled Settings is not boolean: ${enabled}`);
    }
}
exports.InvalidProxyEnabledSettings = InvalidProxyEnabledSettings;
class InvalidProxyUriSettings extends Error {
    constructor(uri) {
        super(`Proxy Uri Settings is not valid: ${uri}`);
    }
}
exports.InvalidProxyUriSettings = InvalidProxyUriSettings;
