"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidNativeDebug = exports.InvalidAppletDebug = exports.validKeys = void 0;
exports.default = validateDebugSettings;
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    appletEnabled: true,
    nativeEnabled: true,
};
function validateDebugSettings(settings) {
    var _a;
    const { appletEnabled, nativeEnabled } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notAppletEnabledValid = !(typeof appletEnabled === 'boolean');
    const notNativeEnabledValid = !(typeof nativeEnabled === 'boolean');
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notAppletEnabledValid) {
        validation.addError(new InvalidAppletDebug(appletEnabled));
    }
    if (notNativeEnabledValid) {
        validation.addError(new InvalidNativeDebug(nativeEnabled));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidAppletDebug extends Error {
    constructor(appletEnabled) {
        super(`Applet Debug setting is not boolean: ${appletEnabled}`);
    }
}
exports.InvalidAppletDebug = InvalidAppletDebug;
class InvalidNativeDebug extends Error {
    constructor(nativeEnabled) {
        super(`Native Debug setting is not boolean: ${nativeEnabled}`);
    }
}
exports.InvalidNativeDebug = InvalidNativeDebug;
