"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidConnectionMethodSettings = void 0;
exports.default = validateConnectionMethodSettings;
const Validation_1 = require("../../../Validation/Validation");
const DeviceSettings_1 = require("../DeviceSettings");
function validateConnectionMethodSettings(settings) {
    const isValidConnectionMethod = settings === null || Object.values(DeviceSettings_1.SocketDriver).includes(settings);
    const validation = (0, Validation_1.createValidation)(settings);
    if (!isValidConnectionMethod) {
        validation.addError(new InvalidConnectionMethodSettings(settings));
    }
    return validation.getOutput();
}
class InvalidConnectionMethodSettings extends Error {
    constructor(value) {
        super(`Connection Method Settings is not valid: ${value}`);
    }
}
exports.InvalidConnectionMethodSettings = InvalidConnectionMethodSettings;
