"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.UnexpectedAttributesApplicationVersionSettings = exports.InvalidApplicationVersion = exports.validKeys = void 0;
exports.default = validateApplicationVersionSettings;
const isValidSemVer_1 = require("../../../Validation/isValidSemVer");
const Validation_1 = require("../../../Validation/Validation");
const validateKeys_1 = require("../../../Validation/validateKeys");
exports.validKeys = {
    version: true,
};
function validateApplicationVersionSettings(settings) {
    var _a;
    const { version } = (_a = settings) !== null && _a !== void 0 ? _a : {};
    const notValidVersion = !(0, isValidSemVer_1.default)(version);
    const validation = (0, Validation_1.createValidation)(settings);
    const keysValidation = (0, validateKeys_1.default)(settings, exports.validKeys);
    if (notValidVersion) {
        validation.addError(new InvalidApplicationVersion(version));
    }
    validation.addError(...keysValidation.getErrors());
    return validation.getOutput();
}
class InvalidApplicationVersion extends Error {
    constructor(version) {
        super('Application Version Settings requires attribute version in form of a semver string.' +
            ` About semver see more here: https://semver.org/. Got: ${JSON.stringify(version)}`);
    }
}
exports.InvalidApplicationVersion = InvalidApplicationVersion;
class UnexpectedAttributesApplicationVersionSettings extends Error {
    constructor(settings) {
        super(`Application Version settings contains unexpected attributes: ${JSON.stringify(settings)}`);
    }
}
exports.UnexpectedAttributesApplicationVersionSettings = UnexpectedAttributesApplicationVersionSettings;
