"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApplicationVersionBuildRequestStatus = void 0;
/**
 * This enum describes the states in which application version build request can be
 * It is used only for fetching
 */
var ApplicationVersionBuildRequestStatus;
(function (ApplicationVersionBuildRequestStatus) {
    /** Completed ApplicationVersionBuildRequests have buildSince specified */
    ApplicationVersionBuildRequestStatus["COMPLETED"] = "Completed";
    /** Building ApplicationVersionBuildRequests do not have buildSince and failedAt specified */
    ApplicationVersionBuildRequestStatus["BUILDING"] = "Building";
    /** Failed ApplicationVersionBuildRequests have failedAt specified */
    ApplicationVersionBuildRequestStatus["FAILED"] = "Failed";
})(ApplicationVersionBuildRequestStatus || (exports.ApplicationVersionBuildRequestStatus = ApplicationVersionBuildRequestStatus = {}));
