"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.InvalidThresholdPercentage = exports.InvalidThresholdType = exports.InvalidThresholdTypeInput = void 0;
exports.default = isThresholdValid;
const Validation_1 = require("../../Validation/Validation");
function isThresholdValid(threshold) {
    const validation = (0, Validation_1.createValidation)(threshold);
    const isValid = typeof threshold === 'object';
    if (!isValid) {
        validation.addError(new InvalidThresholdTypeInput());
    }
    else {
        const thresholdObj = threshold;
        if (thresholdObj.type !== 'percentage') {
            validation.addError(new InvalidThresholdType(thresholdObj));
        }
        else {
            const isValidThresholdInterval = typeof thresholdObj.percentage === 'number' && thresholdObj.percentage >= 0 && thresholdObj.percentage < 99;
            if (!isValidThresholdInterval) {
                validation.addError(new InvalidThresholdPercentage(thresholdObj));
            }
        }
    }
    return validation.getOutput();
}
class InvalidThresholdTypeInput extends Error {
    constructor() {
        super('Threshold input is not a object');
    }
}
exports.InvalidThresholdTypeInput = InvalidThresholdTypeInput;
class InvalidThresholdType extends Error {
    constructor(threshold) {
        super(`Threshold type is not valid : ${JSON.stringify(threshold)}`);
    }
}
exports.InvalidThresholdType = InvalidThresholdType;
class InvalidThresholdPercentage extends Error {
    constructor(threshold) {
        super(`Threshold percentage is not valid : ${JSON.stringify(threshold)}, min 0, max 99`);
    }
}
exports.InvalidThresholdPercentage = InvalidThresholdPercentage;
