declare module '*.module.sass' {
	const styles: Record<string, string>;

	export default styles;
}

declare module '*.sass' {}

declare module '*.svg' {
	import { FC } from 'react';
	const styles: FC;

	export default styles;
}

declare module 'whatwg-fetch' {
	export const fetch: Window['fetch'];
}

declare module 'circular-json' {
	const CircularJSON: {
		stringify(value: unknown): string;
	};

	export default CircularJSON;
}

declare module './config/parameters.mjs' {
	export const getBuildtimeParameters: (path: string) => Promise<any>;
	export const getDefaultAbsoluteRootPath: () => string;
}
