"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.polyfillFetch = exports.getNativeResponse = void 0;
const globalThis_1 = __importDefault(require("../ponyfill/globalThis"));
let NativeResponse;
const getNativeResponse = () => NativeResponse !== null && NativeResponse !== void 0 ? NativeResponse : globalThis_1.default.Response;
exports.getNativeResponse = getNativeResponse;
function polyfillFetch() {
    NativeResponse = globalThis_1.default.Response;
    const { fetch: whatwgFetch } = require('whatwg-fetch'); // will polyfill if fetch is not available
    const originalFetch = globalThis_1.default.fetch;
    globalThis_1.default.fetch = function (input, init) {
        // native fetch does not work for "filesystem:" requests used internally by the "webkitFilesystem"
        if (isWebkitFileSystemUri(input)) {
            return whatwgFetch(input, init);
        }
        return originalFetch(input, init);
    };
}
exports.polyfillFetch = polyfillFetch;
function isWebkitFileSystemUri(input) {
    const url = typeof input === 'string' ? input : input.url;
    return url.startsWith('filesystem:');
}
//# sourceMappingURL=fetch.js.map